/* 	-------------------------------------------------------------------
	CAL3D export
	version : 1.04.00
	Based on the 0.9.1 'maxscript-extended' version of the exporter for Max6

Copyright (C) 2004 Mekensleep

Mekensleep
24 rue vieille du temple
75004 Paris
      licensing@mekensleep.com

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

Authors:
 Philippe Lamoureux <box@phlam.net>
	-------------------------------------------------------------------

        -----Modifications for Vizard Cal3d Exports:-----
   
  Version 0.2 ----
   I've now been working on simplifying a number of new features. Most of this
   involved adding in GUI elements so prefixes and suffixes can be changed
   without having to edit the script manually. I've also added in a few other
   features that should make exporting mass amounts of models much faster.
   
   The new features include:
  -The option to pick a directory to load an export files sequentially based on
   alphabetical order using the "Export and Load Next" button.

  -User can select what the next file will be by using a spinner. Future versions
   may include an option to choose an interval. By default the next file will be the
   next one in alphabetical order.

  -The option to include a line to flip the textures has now been shifted to the
   GUI as a checkbox captioned "Unflip Flipped Textures" under Configuration.

  -The options for suffixes and prefixes to the files have been greatly enhanced
   
--------------------------------------------------------------------
   The current version (0.1) of this mod works by global variables that 
   have to be edited directly in the maxscript. Later versions will likely 
   make use of the existing GUI, allowing the suffix names to be changed 
   there, and allowing each part to be enabled/disabled with a checkbox.
   
   Later versions may also include the ability to import and export 
   settings for when files have the same setup.
   
   
  Version 0.1 ----
  -To fix problems with flipped UVW coordinates, set doFlip to 1. Set to 0 
   to disable.
   
  -Global variable cfgName is what you want your cfg file to be called. To
   use the name of your current 3ds max file (wihtout the extention), set 
   the value to: 
                    substring maxFileName 1 (maxFileName.count - 4)
   
  -Global variable skelName picks a suffix for the skeleton and 
   animation files. 
   This makes it easy to keep the skeleton and animations from one set of 
   avatars from overwriting that of another. Note that in Cal3d,
   animations only work correctly with the skeleton they were exported on.
   
   
  Mod written by Michael Nicolayeff of Worldviz LLC
	------------------------------------------------------------------- */
/* ----------------------To Do-------------------------
-- Find source of crash
-- Set directory of current file as default batch directory
*/-------------------------------------------------------
--Original global variables

global cal3DexportR
try (destroyDialog cal3DexportR) catch()
global cal3DDataVersion = 1.0
global cal3DDataNodeName = "cal3D_data"

--Batch Export Stuff
global preSkel ="" as string
global sufSkel ="" as string

global preMesh ="" as string
global sufMesh ="" as string

global preMat ="" as string
global sufMat ="" as string

global preAni ="" as string
global sufAni ="" as string

global batchPath = ""
global batchCurrentName = getFilenameFile maxFileName

global batchCurrentNum = 1 as integer
global batchNextNum = 2  as integer
global batchNextName = ""
global theFiles

---------------------------------------------------------------------------
---------------------------------------------------------------------------
--	getStringKey / setStringKey
--	Same commands as GetINIsetting and setINIsetting, but works on string buffers
---------------------------------------------------------------------------
global setStringKey, getStringKey
---------------------------------------------------------------------------
fn setStringKey &sbuff section myKey myValue =
--	Writes a [section/]key in a string buffer
--	If myValue is an empty string, the key is erased, and the section too
--	  if there is no key anymore in the section
---------------------------------------------------------------------------
(
	if (myValue==undefined) then myValue=""
	if (section=="") or (myKey=="") then
	(
		MessageBox "setStringKey error : wrong data format"
		return()
	)

	local startKey = myKey+"="
	local lignes = filterstring sbuff "\r\n"
	local i, section_indexes = #(), bonne_section=0, bonne_ligne=0

	if (lignes.count != 0) then
	(
		--	List the sections
		for i=1 to lignes.count do
		(
			if (lignes[i]!="") and (lignes[i][1]=="[") and (lignes[i][lignes[i].count]=="]") then
				append section_indexes i
		)
		append section_indexes (lignes.count+1)

		--	Seek the right section
		for i=1 to (section_indexes.count-1) do
			if (lignes[section_indexes[i]]=="["+section+"]") then
				bonne_section = i
		--	If the section is OK, look for the key
		if (bonne_section!=0) then
		(
			for i=section_indexes[bonne_section] to (section_indexes[bonne_section+1]-1) do
			(
				if ( (substring lignes[i] 1 startKey.count)==startKey) then
					bonne_ligne = i
			)
		)
		--	else, append the section at the end (if myKey is not empty)
		else if (myValue !="") then
		(
			append lignes ("["+section+"]")
			bonne_ligne = lignes.count + 1
		)

		--	If the key is found, update its content
		if (bonne_ligne != 0) then
		(
			-- if myValue is empty, delete the key and maybe the section
			if (myValue=="") then
			(
				deleteItem lignes bonne_ligne
				--	If the number of keys in the section is below 2, delete the section
				if (section_indexes[bonne_section + 1] - section_indexes[bonne_section] - 1 < 2 ) then
					deleteItem lignes section_indexes[bonne_section]
			)
			else
				lignes[bonne_ligne] = myKey + "=" + myValue
		)
		--	else insert the key before the end of the section
		else
		(
			if (myValue!="") then
			(
				bonne_ligne = section_indexes[bonne_section+1]
				insertItem (myKey + "=" + myValue) lignes bonne_ligne
			)
		)
	)
	else
	(
		if (myValue!="") then
			lignes = #( ("["+section+"]"), (myKey + "=" + myValue) )
	)
	--	Re-create the string buffer
	sbuff = ""
	if (lignes.count != 0) then
	(
		for i in lignes do sbuff=sbuff+i+"\r\n"
	)
)

---------------------------------------------------------------------------
fn getStringKey sbuff section myKey =
--	Returns the value of a 'myKey' key in the 'section' section of a string buffer
--	Returns "" if the key or its section does not exist
---------------------------------------------------------------------------
(
	if (section=="") or (myKey=="") then
	(
		MessageBox "getStringKey error : wrong data format"
		return ""
	)
	local startSection = "["+section+"]"
	local startKey = myKey+"="
	local lignes = filterstring sbuff "\r\n"
	local i, section_indexes=#(), bonne_section=0, bonne_ligne=0

	if (lignes.count == 0) then return ""						--	If there is nothing, returns ""
	--	Lists the sections
	for i=1 to lignes.count do
	(
		if (lignes[i]!="") and (lignes[i][1]=="[") and (lignes[i][lignes[i].count]=="]") then
			append section_indexes i
	)
	append section_indexes (lignes.count+1)
	--	Seek the right section
	for i=1 to (section_indexes.count-1) do
		if (lignes[section_indexes[i]]==startSection) then
			bonne_section = i
	if (bonne_section==0) then return ""						--	the section is not found, return ""
	for i=section_indexes[bonne_section] to (section_indexes[bonne_section+1]-1) do
	(
		if ( (substring lignes[i] 1 startKey.count)==startKey) then
			bonne_ligne = i
	)
	if (bonne_ligne == 0) then return ""						--	the key is not found, return ""
	return ( substring lignes[bonne_ligne] (1+startkey.count) -1 )	--	return the myKey value
)
---------------------------------------------------------------------------
---------------------------------------------------------------------------

--	-------------------------------------------------------------------
--	-------------------------------------------------------------------
rollout cal3DexportR "Vizard Cal3D Multi-export" width:464 
(
	local aList=#()						--	Animations data array
	--	each element is a 5 items array
	--	#( <string>Animation_name, <int>start_frame, <int>end_frame, <bool>full_skeleton, <string>bones_NamedSelectionSet )
	local selectedAnimIdx = 0			--	Index of the selected animation
	local nssList = #()					--	Selection Sets Names

	--	-------------------------------------------------------------------
	fn backSlash dir =
	--	Ensures the given 'dir' directory path has a tailing '\' character
	--	Returns the (corrected) directory path string
	--	-------------------------------------------------------------------
	(
		if (dir[dir.count]!="\\") then dir = dir + "\\"
		return dir
	)
	local configFile = (backslash (getDir #plugcfg)) + "cal3DExport.cfg"	--	general config file path

	-----------------------------------

	--Meshes and Skeleton
	GroupBox grp1 "Meshes && Skeleton -------- " pos:[8,8] width:216 height:192
    checkbox chkAuto "Autodetect" pos:[140,8] height:16 checked: true
	label lbl11 "Objects" pos:[16,36] width:40 height:16
	dropdownList ddlObjSet "" pos:[80,32] width:136 height:21
	checkbox chkIndexMat "Re-index materials" pos:[80,56] width:136 height:16 enabled:true checked:true
	checkbox chkLOD "LOD creation" pos:[80,72] width:136 height:16
	checkbox chkSprings "Spring system" pos:[32,88] width:96 height:16
	dropdownList ddlSprings "" pos:[80,104] width:136 height:21
	label lbl13 "Skel. root(s)" pos:[16,138] width:64 height:16
	dropdownList ddlSkelSet "" pos:[80,136] width:136 height:21
	label lbl9 "Max bones by vertex" pos:[48,160] width:104 height:16
	spinner spnMaxBones "" pos:[152,160] width:64 height:16 range:[1,999,4] type:#integer
	label lbl10 "Min weight threshold" pos:[48,176] width:104 height:16
	spinner spnMinThres "" pos:[152,176] width:64 height:16 range:[0.001,1,0.001]
	
	-----------------------------------
	
	--Miniviewer
	GroupBox grp4 "Cal3D mini-viewer" pos:[8,200] width:216 height:56
	checkbox chkCreateCFG "Create cal3D.cfg" pos:[24,216] width:112 height:16 checked:true enabled:true 
	checkbox chkPreviewCFG "Preview cal3D.cfg" pos:[24,232] width:112 height:16

	-----------------------------------
	
	--Animations
	GroupBox grp2 "Animations" pos:[232,8] width:224 height:248
	listbox lbxAnims "" pos:[256,48] width:160 height:8
	button btnAnimAdd "+" pos:[424,48] width:24 height:16 toolTip:"Add an animation entry"
	button btnAnimDel "-" pos:[424,72] width:24 height:16 toolTip:"Delete the selected animation entry"
	button btnAnimUp "up" pos:[424,120] width:24 height:16 toolTip:""
	button btnAnimDn "dn" pos:[424,144] width:24 height:16
	label lbl6 "Name" pos:[248,168] width:32 height:16
	edittext edtAnimName "" pos:[284,168] width:160 height:16
	label lbl7 "Start" pos:[254,189] width:24 height:16
	spinner spnAnimStart "" pos:[287,188] width:48 height:16 range:[0,10000,0] type:#integer scale:1
	button btnAnimRange "|< >|" pos:[342,190] width:26 height:14 toolTip:"Use the active segment for the start and end frames"
	label lbl12 "End" pos:[372,190] width:24 height:16
	spinner spnAnimEnd "" pos:[396,188] width:48 height:16 range:[0,10000,0] type:#integer scale:1
	radiobuttons rdoSkelType "" pos:[248,208] width:195 height:16 labels:#("Full skeleton", "Bones set") columns:2
	dropdownList ddlBonesSet "" pos:[288,224] width:157 height:21

	-----------------------------------
	
	--Configuration	
	GroupBox grp3 "Configuration" pos:[8,264] width:448 height:96
	label lbl19 "File format" pos:[24,280] width:56 height:16
	radiobuttons rdoFormat "" pos:[96,280] width:118 height:16 enabled:true labels:#("Binary", "XML") columns:2
	checkbox chkTransform "OpenGL Coordinate system" pos:[24,296] height:16
	label lb210 "Scale factor" pos:[320,280] width:64 height:16
	spinner spnScale "" pos:[384,280] width:64 height:16 range:[0.001,100000,1]
	checkbox chkTexFlip "Unflip Flipped Textures" pos:[320,296] height:16 checked:true
	label lbl40 "Sampling rate (frames)" pos:[248,24] width:104 height:16
	spinner spnSRate "" pos:[368,24] width:48 height:16 range:[0,100,1] type:#integer scale:1
	button btnViewerPath "Viewer path" pos:[16,320] width:72 height:16
	edittext lblViewerPath "" pos:[88,320] width:360 height:16 readOnly:true
	button btnExportDir "Export dir" pos:[16,336] width:72 height:16
	edittext lblExportDir "" pos:[88,336] width:360 height:16 readOnly:true
	button btnSaveConfig "Save config" pos:[8,368] width:80 height:24
	button btnExport "Export" pos:[170,368] width:112 height:24
	button btnAbort "Cancel" pos:[352,368] width:80 height:24

	-----------------------------------	
	
	--Batch Options
	button btnHelpMe "?" pos:[432,368] width: 24 height:24 enabled:false

	GroupBox grpBatch "Batch Options" pos:[8,400] width:448 height:104
	button btnExpGetNext "Export & Load Next" pos:[16,416] width:200 height:32 enabled:false
	button btnLoadFile "Pick Directory" pos:[224,416] width:224 height:16 tooltip:"Picks the directory and loads file that appears first in aphabetical order."
	button btnSkipFile "Skip To Next" pos:[224,432] width:112 height:16 enabled:false
	label lbInterval "Increment by:" pos:[344,434]  height:16
	spinner spnInterval "" pos:[408,432] width:40 height:16 range:[1,10,1] enabled:false type:#integer scale:.01
	edittext lblDirectory "Batch Directory:" pos:[16,456] width:432 height:16 readOnly:true text:"(Displays the current batch directory)"
	edittext lblCurrentFile "Current:" pos:[16,480] width:200 height:16 readOnly:true text:(getFilenameFile maxFileName)
	edittext lblNextFile "Next:" pos:[224,480] width:180 height:16 readOnly:true text:"(Displays next file)"
	spinner spnFileNum "" pos:[408,480] width:40 height:16 range:[1,1,1] enabled:false type:#integer scale:1


	-----------------------------------

	--Prefix and Suffix Options
	GroupBox grpPrefix "Prefix and Suffix Options" pos:[8,512] width:448 height:104
	checkbox chkPreSkel "Skeleton Prefix:" pos:[16,528] height:16
	edittext edtPreSkel "" pos:[116,528] width:160 height:16
	checkbox chkPreMesh "Mesh Prefix: (uses filename)" pos:[286,528] height:16
	checkbox chkPreAni "Animation Prefix:" pos:[16,544] height:16
	edittext edtPreAni "" pos:[116,544] width:160 height:16
	checkbox chkPreMat "Material Prefix: (uses filename)" pos:[286,544] height:16
	checkbox chkSuf "Suffix:" pos:[16,574] height:16
	edittext edtSuf "" pos:[64,574] width:154 height:16
	label lblSApply "Apply to:" pos:[16,596] height:16
	checkbox chkSufSkel "Skeleton" pos:[66,596] height:16 enabled:false
	checkbox chkSufMesh "Mesh" pos:[142,596] height:16 enabled:false
	checkbox chkSufAni "Animation" pos:[202,596] height:16 enabled:false
	checkbox chkSufMat "Material" pos:[282,596] height:16 enabled:false



	--	-------------------------------------------------------------------
	fn displayAnim num =
	--	Fills the fields of the currently selected (num) animation data
	--	Disbles the controls if there is no animation data (aList is an empty array)
	--	-------------------------------------------------------------------
	(
		if (num == 0) then
		(
			edtAnimName.enabled = spnAnimStart.enabled = spnAnimEnd.enabled = rdoSkelType.enabled = OFF
			ddlBonesSet.enabled = btnAnimDel.enabled = btnAnimUp.enabled = btnAnimDn.enabled = OFF
			btnAnimRange.enabled = OFF
			edtAnimName.text = ""
			spnAnimStart.value = 0
			spnAnimEnd.value = 100
			return()
		)
		else
		(
			edtAnimName.enabled = spnAnimStart.enabled = spnAnimEnd.enabled = rdoSkelType.enabled = ON
			btnAnimDel.enabled = btnAnimUp.enabled = btnAnimDn.enabled = btnAnimRange.enabled = ON
		)
		lbxAnims.selection = num
		edtAnimName.text = aList[num][1]
		spnAnimStart.value = aList[num][2]
		spnAnimEnd.value = aList[num][3]
		if aList[selectedAnimIdx][4] then
		(
			rdoSkelType.state = 2
			ddlBonesSet.enabled = ON
			nSet = findItem nssList aList[selectedAnimIdx][5]
			if (nSet != 0) then ddlBonesSet.selection = nSet
		)
		else
		(
			rdoSkelType.state = 1
			ddlBonesSet.enabled = OFF
			ddlBonesSet.selection = 1
		)
	)
	--	-------------------------------------------------------------------
	fn displayAnimList =
	--	Fills the animations list listbox
	--	-------------------------------------------------------------------
	(
		lbxAnims.items = for a in aList collect ((a[2] as string) + "-" + (a[3] as string) + "   " + a[1] )
	)
	--	-------------------------------------------------------------------
	fn getChildren nodlist &fullList =
	--	Lists (to the fullList array) every nodes and their descending
	--	hierarchies listed in the nodList array.
	--	nodList : Array of the root nodes
	--	fullList : empty array (filled with the result)
	--	-------------------------------------------------------------------
	(
		for n in nodList do
		(
			append fulllist n
			getChildren n.children &fullList
		)
	)
	--	-------------------------------------------------------------------
	fn getMatIndex mname =
	--	Returns as an integer the index written at the end of the given 'mname' string
	--	Used in the CAL3D Material names ("<material_name> [<index>]")
	--	-------------------------------------------------------------------
	(
		if mname[mname.count]!="]" then return -1
		idx = mname.count
		while (idx>0) and (mname[idx]!="[") do idx-=1
		index = substring mname (idx+1) (mname.count - idx - 1)
		return (index as integer)
	)

	--	-------------------------------------------------------------------
	fn setMatIndex mname index =
	--	Returns the 'mname' string ending with " [<index>]"
	--	Used in the CAL3D Material names ("<material_name> [<index>]")
	--	-------------------------------------------------------------------
	(
		idx = mname.count
		if mname[idx]=="]" then
		(
			while (idx>0) and (mname[idx]!="[") do idx-=1
			idx = amax #(1, idx-1)
			while (idx>0) and (mname[idx]==" ") do idx-=1
		)
		return ((substring mname 1 idx) + " [" + (index as string) + "]")
	)

	--	-------------------------------------------------------------------
	fn loadConfig =
	--	Loads the general Cal3D_Export script configuration
	--	-------------------------------------------------------------------
	(
		lblViewerPath.text = getINIsetting configFile "Directories" "viewerPath"
		tmp = getINIsetting configFile "Directories" "Format"
		if tmp=="" then tmp="1"
		rdoFormat.state = tmp as Integer
		chkTransform.checked = (getINIsetting configFile "Options" "Transform") == "true"
		tmp = (getINIsetting configFile "Options" "Scale") as Float
		spnScale.value = if (tmp != 0.0) then tmp else 1.0
		spnSRate.value = (getINIsetting configFile "Options" "SamplingRate") as integer
	)
	--	-------------------------------------------------------------------
	fn saveConfig =
	--	Saves the general Cal3D_Export script configuration
	--	-------------------------------------------------------------------
	(
		setINIsetting configFile "Directories" "viewerPath" lblViewerPath.text
		setINIsetting configFile "Directories" "Format" (rdoFormat.state as string)
		setINIsetting configFile "Options" "Transform" (chkTransform.checked as String)
		setINIsetting configFile "Options" "Scale" (spnScale.value as string)
		setINIsetting configFile "Options" "SamplingRate" (spnSRate.value as string)
	)
	--	-------------------------------------------------------------------
	fn loadExportParam =
	--	Loads the in-file Cal3D_Export local configuration :
	--	. Used Named-Selection-Sets (Objects, Skeleton roots)
	--	. Parameters
	--	. Animation entries : List of {Name / Start / End / Bones set} items
	--	Fills the aList array with the animation data
	--	-------------------------------------------------------------------
	(
		aList = #()	
		lblExportDir.text = backslash (getDir #Export)
		cal3DDataNode = getNodeByName cal3DDataNodeName
		if (cal3DDataNode==undefined) then return #()
		sbuff = getUserPropBuffer cal3DDataNode
		if (sbuff=="") then return #()
		if ((getStringKey sbuff "general" "name") != "cal3D") then
		(
			MessageBox ("Error, wrong User Properties format placed in the node "+cal3DDataNodeName)
			return #()
		)
		ver = (getStringKey sbuff "general" "version") as float
		if (ver != cal3DDataVersion) then
		(
			-- Different cal3D data versions
		)
		else
		(

		
			tmp = getStringKey sbuff "general" "exportDir"
			if (tmp=="") then tmp=getDir #Export
			lblExportDir.text = backSlash tmp
			chkCreateCFG.checked = (getStringKey sbuff "general" "generateCFG")== "true"
			chkPreviewCFG.checked = (getStringKey sbuff "general" "LaunchPreview")== "true"

			--	Get the meshes set
			nssn = getStringKey sbuff "export" "meshSet"
            ddlObjSet.selection = if ((idx = findItem nssList nssn) != 0) then idx else 1

			chkIndexMat.checked = (getStringKey sbuff "export" "ReIndexMat")== "true"
			chkLOD.checked = (getStringKey sbuff "export" "LOD")== "true"
			chkSprings.checked = (getStringKey sbuff "export" "Springs")== "true"

			--	Get the springs set
			nssn = getStringKey sbuff "export" "springSet"
			ddlSprings.selection = if ((idx = findItem nssList nssn) != 0) then idx else 1

			--	Get the skeleton roots set
			nssn = getStringKey sbuff "export" "skelSet"
			ddlSkelSet.selection = if ((idx = findItem nssList nssn) != 0) then idx else 1

			--	Get the animations list
			num = (getStringKey sbuff "export" "anmNumber") as integer
			for i=1 to num do
			(
				anmName = getStringKey sbuff ("anim" + i as string) "Name"
				anmStart = (getStringKey sbuff ("anim" + i as string) "Start") as integer
				anmEnd = (getStringKey sbuff ("anim" + i as string) "End") as integer
				anmUseBSet = (getStringKey sbuff ("anim" + i as string) "useBonesSet") == "true"
				anmBSet = getStringKey sbuff ("anim" + i as string) "BonesSet"
				append aList #(anmName, anmStart, anmEnd, anmUseBSet, anmBSet)
			)

			--	Get the Max Bones parameters
			spnMaxBones.value = (getStringKey sbuff "general" "MaxBones") as integer
			spnMinThres.value = (getStringKey sbuff "general" "MinThreshold") as float
		)
	)
	--	-------------------------------------------------------------------
	fn saveExportParam =
	--	Saves the in-file Cal3D_Export local configuration
	--	Makes 3DSMax need to save the scene
	--	-------------------------------------------------------------------
	(
		sbuff = ""
		setStringKey &sbuff "general" "name" "cal3D"
		setStringKey &sbuff "general" "version" (cal3DDataVersion as string)
		setStringKey &sbuff "general" "exportDir" lblExportDir.text
		setStringKey &sbuff "general" "generateCFG" (chkCreateCFG.checked as string)
		setStringKey &sbuff "general" "LaunchPreview" (chkPreviewCFG.checked as string)
		setStringKey &sbuff "general" "MaxBones" (spnMaxBones.value as string)
		setStringKey &sbuff "general" "MinThreshold" (spnMinThres.value as string)

		setStringKey &sbuff "export" "meshSet" ddlObjSet.selected
		setStringKey &sbuff "export" "ReIndexMat" (chkIndexMat.checked as string)
		setStringKey &sbuff "export" "LOD" (chkLOD.checked as string)
		setStringKey &sbuff "export" "Springs" (chkSprings.checked as string)
		setStringKey &sbuff "export" "springSet" ddlSprings.selected

		setStringKey &sbuff "export" "skelSet" ddlSkelSet.selected
		setStringKey &sbuff "export" "anmNumber" (aList.count as string)
		for i=1 to aList.count do
		(
			setStringKey &sbuff ("anim" + i as string) "Name" aList[i][1]
			setStringKey &sbuff ("anim" + i as string) "Start" (aList[i][2] as string)
			setStringKey &sbuff ("anim" + i as string) "End" (aList[i][3] as string)
			setStringKey &sbuff ("anim" + i as string) "useBonesSet" (aList[i][4] as string)
			val = if aList[i][4] then aList[i][5] else ""
			setStringKey &sbuff ("anim"+i as string) "BonesSet" val
		)
		cal3DDataNode = getNodeByName cal3DDataNodeName
		if (cal3DDataNode==undefined) then
		(
			cal3DDataNode = point name:cal3DDataNodeName
			cal3DDataNode.isFrozen=true
		)
		setUserPropBuffer cal3DDataNode sbuff
		setSaveRequired ON
	)
	--	-------------------------------------------------------------------
	fn exportData =
	--	Export the skeleton / mesh / animations files
	--	Returns an empty string in case of succes
	--	Returns an error message string in case of failure
	--	-------------------------------------------------------------------
	(
		oldCommandPanelTaskMode = getCommandPanelTaskMode()

		--	Need the TimeSlider on frame 0
				oldAnimationRange = animationRange
				animationRange = interval 0f animationRange.end
				oldSliderTime = sliderTime
				sliderTime = 0f

		--	Export every object
		local expType = if rdoFormat.state==1 then "C" else "X"
		local exportDir = lblExportDir.text
		try ( objSet = for obj in selectionSets[ddlObjSet.selected] collect obj )
		catch ( return "The Named Selection Set that lists the objects is invalid" )
		if chkSprings.checked then
		(
			try ( for obj in selectionSets[ddlSprings.selected] where ((finditem objSet obj)==0) do append objSet obj )
			catch ( return "The Named Selection Set that lists the cloth objects is invalid" )
		)

		--	Skeleton

		skeletonfile = (exportDir as string) + (preSkel as string) + "Skeleton" + (sufSkel as string) + "."+(expType as string) +"SF"
		try ( SRootsSet = for obj in selectionSets[ddlSkelSet.selected] collect obj )
		catch ( return "The Named Selection Set that lists the skeleton roots is invalid" )
		res = exportcalskel skeletonfile SRootsSet off transform:chkTransform.checked
		case res of
		(
			(-2) : return "An Exception occured in the ExportSkeleton plugin function"
			(-1) : return "ExportSkeleton didn't work"
			 1 : return ("Verify the path for the skeleton file :\n" + skeletonFile)
			 2 : return "The Named Selection Set that lists the skeleton roots is empty"
			 3 : return "The Named Selection Set that lists the skeleton roots contains invalid references"
		)

		--	Mat & Mesh
		num=0
		for obj in objSet do
		(
			--	Filename validity verification
			wrongChars = "\\/:*?\"<>|"
			for w=1 to wrongChars.count do
			(
				if (findString obj.name wrongChars[w] != undefined) then
					return ("The following object has a filename-related invalid name :	\n"+obj.name+"\nIt should not contain any of these characters "+wrongChars)
			)

			--	Re-index materials
			mat = obj.material
			case (classof mat) of
			(
				StandardMaterial:
				(
					if chkIndexMat.checked then
					(
						mat.name = setMatIndex mat.name num
						num+=1
						--	Export material
						materialFile = exportDir + preMat + obj.name + sufMat+ "." + expType + "RF"
						res = exportcalmat materialFile mat
					)
				)
				MultiMaterial:
				(
					if chkIndexMat.checked then
					(
						for i=1 to mat.materialList.count do
						(
							mat.materialList[i].name = setMatIndex mat.materialList[i].name num
							num+=1

							--	Export material
							materialFile = (exportDir as string) + (preMat as string) + (obj.name as string) + "_" + (i as String) + (sufMat as string) + "." + (expType as string) + "RF"
							res = exportcalmat materialFile mat.materialList[i]
							if (res!=0) then exit
						)
					)
				)
				default:
				(
					return "The material assigned to "+obj.name+" is not a Standard- nor a Multi- material"
				)
			)
			case res of
			(
				(-2) : return "An Exception occured in the ExportMaterial plugin function"
				(-1) : return "ExportMaterial didn't work"
				 1 : return ("Verify the path for the material file : \n" + materialFile)
				 2 : return "No good material"	--	already checked before the export (will never appear)
				 3 : return "No good material"	--	already checked before the export (will never appear)
			)

			--	Export Mesh
			meshFile = exportDir + preMesh + obj.name + sufMesh + "."+expType+"MF"

			if (getCommandPanelTaskMode() == #modify) then
				setCommandPanelTaskMode mode:#create

			isaCloth = chkSprings.checked and ((findItem selectionSets[ddlSprings.selected] obj)!=0)
			res = exportcalmesh meshfile skeletonfile obj spnMaxBones.value spnMinThres.value chkLOD.checked isaCloth  transform:chkTransform.checked
			case res of
			(
				(-2) : return "An Exception occured in the ExportMesh plugin function"
				(-1) : return "ExportMesh didn't work"
				 1 : return ("Verify the path for the mesh file : \n" + meshFile)
				 2 : return "The skeleton file is not defined"
				 3 : return ("The skeleton file is not a valid file : \n" + skeletonFile)
				 4 : return "The number of bones by vertex is null or negative"
				 5 : return "The min weight threshold is negative"
				 6 : return "The Names Selection Set for the objects cointains invalid mesh nodes"
				 7 : return "The Names Selection Set for the objects cointains invalid mesh nodes"
			)
		)
		--	Animations
		qwerty = false --cheat the animations
		if querty == true do (
		
		for anm in aList do
		(
			local bonesList
			animationFile = exportDir + preAni + anm[1] + sufAni + "."+expType+"AF"
			if anm[4] then
			(
				bonesList = for obj in selectionSets[anm[5]] collect obj
			)
			else
			(
				bonesList = #()
				getChildren SRootsSet &bonesList
			)

			res = exportcalanim animationFile skeletonfile boneslist anm[2] anm[3] spnSRate.value frameRate transform:chkTransform.checked
			case res of
			(
				(-2) : return "An Exception occured in the ExportAnimation plugin function"
				(-1) : return "ExportAnimation didn't work"
				 1 : return ("Verify the path for the material file : \n" + meshFile)
				 2 : return "The skeleton file is not defined"
				 3 : return ("The skeleton file is not a valid file : \n" + skeletonFile)
				 4 : return "The Names Selection Set that lists the bones is empty"
				 5 : return "The Start frame is negative"
				 6 : return "The End frame is negative"
				 7 : return "The Start frame is greater than the End frame"
				 8 : return "The offset (sample rate) is negative"
				 9 : return "The framerate is negative"
				10 : return "The Names Selection Set that lists the bones contains invalid nodes"
			)
		))

		--	Set the environment back to its former state
		animationrange = oldAnimationRange
		sliderTime = oldSliderTime
		if (oldCommandPanelTaskMode != getCommandPanelTaskMode()) then
			setCommandPanelTaskMode mode:oldCommandPanelTaskMode
		return ""
	)
	--	-------------------------------------------------------------------
	fn exportDataCheck =
	--	Calls the exportData process
	--	If no error is returned, creates the cal3D.cfg file and launches the viewer
	--	-------------------------------------------------------------------
	(
		--	Export the data files and check for an error
		err = exportData()
		if (err != "") then
		(
			MessageBox ("Error during the export :\n" + err + "\n\nProcess aborted") title:"CAL3D Export"
			return()
		)
		--	Generate the cal3D.CFG file
		if chkCreateCFG.checked then
		(
			f = createFile (lblExportDir.text + (lblCurrentFile.text) + ".cfg")
			if (f==undefined) then
			(
				MessageBox ("Cannot create the config file\n"+f) title:"CAL3D Export"
				return()
			)
			--	XML or Binary
			extens = if rdoFormat.state==1 then "C" else "X"

			--	Objects to be listed (meshes and clothes)
			nods = for o in selectionSets[ddlObjSet.selected] collect o
			if chkSprings.checked then
				for o in selectionSets[ddlSprings.selected] where ((finditem nods o)==0) do append nods o

			format "################################################\n" to:f
			format "#\n" to:f
			format "# Cal3d cfg File\n" to:f
			format "#\n" to:f
			format "################################################\n" to:f
			format "\n" to:f
			format "scale=%\n" spnScale.value to:f
			if chkTexFlip.checked do (format "flip_texture = 1\n" to:f)
			if printHeadMesh == true do (format "head_mesh=%%%.%MF\n" preMesh nods[1].name sufMesh extens to:f)
			format "\n"to:f
			format "################# Skeleton #################\n" to:f
			format "skeleton=%Skeleton%.%SF\n" preSkel sufSkel extens to:f
			format "\n" to:f
			format "################# Meshes #################\n" to:f
			for meshnod in nods do
				format "mesh=%%%.%MF\n" preMesh meshnod.name sufMesh extens to:f
			format "\n" to:f
			format "################# Animations #################\n" to:f
			
			for anm in aList do
				format "animation=%%%.%AF\n" preAni anm[1] sufAni extens to:f
			format "\n" to:f
			format "################# Materials #################\n" to:f
			for meshnod in nods do
			(
				mat = meshnod.material
				case (classof mat) of
				(
					StandardMaterial:
					(
						format "material=%%%.%RF\n" preMesh meshnod.name sufMesh extens to:f
					)
					MultiMaterial:
					(
						for i=1 to mat.materialList.count do
						(
							format "material=%%_%%.%RF\n" preMesh meshnod.name i sufMesh extens to:f
						)
					)
					default:
					(
						MessageBox ("Grumpfffff, no good material for "+meshnod.name)
					)
				)
			)
			format "\n" to:f
			close f
		)

		--	Preview the cal3D.CFG file
		if chkPreviewCFG.checked then
		(
			local f, viewBatch="c:\\cal3Dpre.bat"
			if ((f = createFile viewBatch)==undefined) then
			(
				MessageBox "Error : Can't create the batch file "+viewBatch+" to launch the mini-viewer" title:"Cal3D Export"
				return()
			)
			delimiter1 = ""
			delimiter2 = ""
			if ((findstring lblExportDir.text " ") != undefined) then delimiter1="\""
			if ((findstring lblViewerPath.text " ") != undefined) then delimiter2="\""
			format "%:\n" lblExportDir.text[1] to:f
			format "cd %%%\n" delimiter1 lblExportDir.text delimiter1 to:f
			format "%%% %.cfg\n" delimiter2 lblViewerPath.text delimiter2 cfgName to:f
			close f
			DOSCommand viewBatch
			deleteFile viewBatch
		)
	)


	--	-------------------------------------------------------------------
	--	Interface events
	--	-------------------------------------------------------------------

	on cal3DexportR open do
	(
		--	Load genral configuration
		loadConfig()

		if not (doesFileExist lblViewerPath.text) then
		(
			lblViewerPath.text = ""
			chkPreviewCFG.enabled=FALSE
		)
		--	Named Selection Sets
		nssList = for i=1 to getNumNamedSelSets() collect (getNamedSelSetName i)
		ddlObjSet.items = nssList
		ddlSprings.items = nssList
		ddlSkelSet.items = nssList
		ddlBonesSet.items = nssList
		--	Animations list
		loadExportParam()
		lbxAnims.items = for a in aList collect a[1]
		displayAnimList()
		--	Show the 1st anim parameters
		selectedAnimIdx = amin #(1, aList.count)
		displayAnim selectedAnimIdx
		
		if (chkAuto.checked) then
		(
			for i=1 to getNumNamedSelSets() do
			(
				if (nssList[i]=="meshes") do ddlObjSet.selection = i -- Selection set with mesh
				if (nssList[i]=="root") do ddlSkelSet.selection = i -- Selection set with mesh
				if (nssList[i]=="bones") do ddlBonesSet.selection = i
			)
		)
		else()
	)
	
	on lbxAnims selected val do
	(
		displayAnim (selectedAnimIdx = val)
	)
	on lbxAnims doubleClicked val do
	(
		animationrange = interval aList[val][2] aList[val][3]
	)
	on btnAnimAdd pressed do
	(
		append aList #("Unnamed", animationrange.Start.frame as integer, animationrange.End.frame as integer, OFF, "")
		displayAnim (selectedAnimIdx = aList.count)
		displayAnimList()
	)
	on btnAnimDel pressed do
	(
		deleteItem aList selectedAnimIdx
		selectedAnimIdx = amin selectedAnimIdx aList.count
		displayAnim selectedAnimIdx
		displayAnimList()
	)
	on btnAnimUp pressed do
	(
		if (selectedAnimIdx <= 1) then return()
		elt = for i=1 to 5 collect aList[selectedAnimIdx][i]
		aList[selectedAnimIdx] = for i=1 to 5 collect aList[selectedAnimIdx-1][i]
		aList[selectedAnimIdx-1] = for i=1 to 5 collect elt[i]
		selectedAnimIdx -= 1
		displayAnim selectedAnimIdx
		displayAnimList()
	)
	on btnAnimDn pressed do
	(
		if (selectedAnimIdx >= aList.count) then return()
		elt = for i=1 to 5 collect aList[selectedAnimIdx][i]
		aList[selectedAnimIdx] = for i=1 to 5 collect aList[selectedAnimIdx+1][i]
		aList[selectedAnimIdx+1] = for i=1 to 5 collect elt[i]
		selectedAnimIdx += 1
		displayAnim selectedAnimIdx
		displayAnimList()
	)
	on edtAnimName changed val do
	(
		aList[selectedAnimIdx][1] = val
		displayAnimList()
	)
	on spnAnimStart changed val do
	(
		aList[selectedAnimIdx][2] = val
		displayAnimList()
	)
	on btnAnimRange pressed do
	(
		spnAnimStart.value = aList[selectedAnimIdx][2] = animationrange.start.frame as integer
		spnAnimEnd.value = aList[selectedAnimIdx][3] = animationrange.end.frame as integer
		displayAnimList()
	)
	on spnAnimEnd changed val do
	(
		aList[selectedAnimIdx][3] = val
		displayAnimList()
	)
	on rdoSkelType changed state do
	(
		aList[selectedAnimIdx][4] = (state==2)
		if ((findItem nssList aList[selectedAnimIdx][5])==0) then
			aList[selectedAnimIdx][5] = ddlBonesSet.items[1]
		displayAnim selectedAnimIdx
		displayAnimList()
	)
	on ddlBonesSet selected val do
	(
		aList[selectedAnimIdx][5] = ddlBonesSet.selected
	)
	on btnViewerPath pressed do
	(
		tmp = getOpenFilename filename:lblViewerPath.text types:"*.exe|*.exe|"
		if (tmp != undefined) then
			lblViewerPath.text = tmp
		chkPreviewCFG.enabled = doesFileExist lblViewerPath.text
	)
	on btnExportDir pressed do
	(
		tmp = getSavePath caption:"Export directory"
		if (tmp != undefined) then
		(
			lblExportDir.text = backSlash tmp
		)
	)
	on btnSaveConfig pressed do
	(
		saveConfig()
		saveExportParam()
	)
	on btnExport pressed do
	(
		saveConfig()
		saveExportParam()
		exportDataCheck()
	)

	on btnAbort pressed do
	(
		destroyDialog cal3DexportR
	)

	
	-------------------------

--------------------------------------
--prefixes and suffixs

--Suffix

	on chkSuf changed theState do
	(
		if thestate then 
		(
			--if turne on, enable other boxes and set suffixes to edtSuf.text where appropriate
			chkSufSkel.enabled = true;
			chkSufMesh.enabled = true;
			chkSufAni.enabled = true;
			chkSufMat.enabled = true;
			if chkSufSkel.checked do sufSkel=edtSuf.text;print sufSkel
			if chkSufMesh.checked do sufMesh=edtSuf.text;print sufMesh
			if chkSufMat.checked do sufMat=edtSuf.text;print sufMat
			if chkSufAni.checked do sufAni=edtSuf.text;print sufAni
		)
		else 
		(
			--if turned off, disable other boxes and set suffixes to null
			chkSufSkel.enabled = false;
			chkSufMesh.enabled = false;
			chkSufAni.enabled = false;
			chkSufMat.enabled = false;
			sufSkel="";print sufSkel
			sufMesh="";print sufMesh
			sufMat="";print sufMat
			sufAni="";print sufAni
		)
	)
	
	on edtSuf entered newText do
	(
		-- update suffixes as appropriate
		if chkSuf.checked do
		(
			if chkSufSkel.checked do sufSkel=newText;print sufSkel
		)
		if chkSuf.checked do
		(
			if chkSufMesh.checked do sufMesh=newText;print sufMesh
		)
		if chkSuf.checked do
		(
			if chkSufMat.checked do sufMat=newText;print sufMat
		)
		if chkSuf.checked do
		(
			if chkSufAni.checked do sufAni=newText;print sufAni
		)
	)

--Skeleton
	on chkPreSkel changed theState do
	(
		if theState then (preSkel=edtPreSkel.text; print preSkel)
		else (preSkel="";print preSkel)
	)
	
	on chkSufSkel changed theState do
	(
		if theState then (sufSkel=edtSuf.text; print sufSkel)
		else (preSkel="";print preSkel)
	)

    on edtPreSkel entered newText do 
	(
		--if corresponding box is checked, change value. If not, do nothing.
		if chkPreSkel.checked do(preSkel=newText; print preSkel)
	)

--Mesh
	on chkPreMesh changed theState do
	(
		if (theState) then (preMesh=batchCurrentName; print preMesh)
		else (preMesh="";print preMesh)
	)
	
	on chkSufMesh changed theState do
	(
		if (theState) then (sufMesh=edtSuf.text; print sufMesh)
		else (preMesh="";print preMesh)
	)
	
--Animation
	on chkPreAni changed theState do
	(
		if (theState) then (preAni=edtPreAni.text; print preAni)
		else (preAni="";print preAni)
	)
	
	on chkSufAni changed theState do
	(
		if (theState) then (sufAni=edtSuf.text; print sufAni)
		else (preAni="";print preAni)
	)
	
	on edtPreAni entered newText do 
	(
	--if corresponding box is checked, change value. If not, do nothing.
	if chkPreAni.checked do (preAni=newText; print preAni)
	)
	
--Material
	on chkPreMat changed theState do
	(
		if (theState) then (preMat=batchCurrentName; print preMat)
		else (preMat="";print preMat)
	)
	
	on chkSufMat changed theState do
	(
		if (theState) then (sufMat=edtSuf.text; print sufMat)
		else (preMat="";print preMat)
	)

	
-----------------------------------------
--other shtuff


	on spnFileNum changed theValue do
	(
	batchNextNum = theValue
	lblNextFile.text = (getFilenameFile theFiles[batchNextNum])
	)



	on btnHelpMe pressed do
	(
	stopit=0
		while (stopit<1) do
		(
			saveConfig()
			saveExportParam()
			exportDataCheck()
	
			--looks at next number and changes current number to match, then increments next number by one.
			if (batchCurrentNum+spnInterval.value>theFiles.count) do (stopit = 1)
			batchCurrentNum=batchNextNum
			batchNextNum = batchCurrentNum + spnInterval.value

			--if the next number would be higher than the number of items in the array, keep it from going higher
			if (batchNextNum>=theFiles.count) do (batchNextNum=theFiles.count;)


			--update boxes
			spnFileNum.value = batchNextNum
			lblDirectory.text = batchPath
			lblCurrentFile.text = getFilenameFile theFiles[batchCurrentNum]
			lblNextFile.text = getFilenameFile theFiles[batchNextNum]
	
			--Load next file
			loadMaxFile theFiles[batchCurrentNum] quiet:true
			gc()	
		
		)
		stopit=0
	)
	

	on btnExpGetNext pressed do
	(
		saveConfig()
		saveExportParam()
		exportDataCheck()

		--looks at next number and changes current number to match, then increments next number by one.
		batchCurrentNum=batchNextNum
		batchNextNum = batchCurrentNum + spnInterval.value

		--if the next number would be higher than the number of items in the array, keep it from going higher
		if (batchNextNum>=theFiles.count) do (batchNextNum=theFiles.count)

		--update boxes
		spnFileNum.value = batchNextNum
		lblDirectory.text = batchPath
		lblCurrentFile.text = getFilenameFile theFiles[batchCurrentNum]
		lblNextFile.text = getFilenameFile theFiles[batchNextNum]

		--Load next file
		print ("btnExpGetNext - batchCurrentNum: " + batchCurrentNum as string)
		print ("btnExpGetNext - The current file: " + theFiles[batchCurrentNum] as string)
		print ("btnExpGetNext - batchNextNum: " + batchNextNum as string)
		print ("btnExpGetNext - The next file: " + theFiles[batchNextNum] as string)
		
		loadMaxFile theFiles[batchNextNum] quiet:true
	)
	
	on btnLoadFile pressed do 
	(
		print "huh?"
		lblDirectory.text = "WTF? OMFG!"
		tmp = getOpenFileName caption:"Pick any max file in initial directory:" types:"Max Files(*.max)|*.max" initial: maxFilePath
		if (tmp != undefined) do
		(
		--enables batch interface elements like the spinner
			spnFileNum.enabled=true
			spnInterval.enabled=true
			btnExpGetNext.enabled=true
			btnSkipFile.enabled=true
			btnHelpMe.enabled=true
			
			batchPath = backslash (getFilenamePath tmp)
			
			theFiles = getFiles (batchPath+"\\*.max")
			
			--number of current file in array
			batchCurrentNum  = 1
			batchNextNum = batchCurrentNum + spnInterval.value
			print batchNextNum
			
			--if the next number would be higher than the number of items in the array, keep it from going higher)
			if (batchNextNum>=theFiles.count) do (batchNextNum=theFiles.count)
			print batchNextNum
			--Update file number spinner			
			spnFileNum.range = [1,theFiles.count,batchNextNum]
			
			--update boxes
			lblDirectory.text = batchPath
			lblCurrentFile.text = getFilenameFile theFiles[batchCurrentNum]
			batchCurrentName = lblCurrentFile.text
			lblNextFile.text = getFilenameFile theFiles[batchNextNum]

			--load the file
			print ("btnLoadFile - batchCurrentNum: " + batchCurrentNum as string)
			print ("btnLoadFile - The current file: " + theFiles[batchCurrentNum] as string)
			print ("btnLoadFile - batchNextNum: " + batchNextNum as string)
			print ("btnLoadFile - The next file: " + theFiles[batchNextNum] as string)
			
			loadMaxFile theFiles[batchCurrentNum] quiet:true
		)
	)

	on btnSkipFile pressed do 
	(
		--looks at next number and changes current number to match, then increments next number by one.
		batchCurrentNum=batchNextNum
		batchNextNum = batchCurrentNum + spnInterval.value
		
		--if the next number would be higher than the number of items in the array, keep it from going higher)
		if (batchNextNum>=theFiles.count) do (batchNextNum=theFiles.count)

		--update boxes
		spnFileNum.value = batchNextNum
		lblDirectory.text = batchPath
		lblCurrentFile.text = getFilenameFile theFiles[batchCurrentNum]
		lblNextFile.text = getFilenameFile theFiles[batchNextNum]
		batchCurrentName = lblCurrentFile.text
	
		--Load next file
		print ("btnSkipFile - batchCurrentNum: " + batchCurrentNum as string)
		print ("btnSkipFile - The current file: " + theFiles[batchCurrentNum] as string)
		print ("btnSkipFile - batchNextNum: " + batchNextNum as string)
		print ("btnSkipFile - The next file: " + theFiles[batchNextNum] as string)
		
		loadMaxFile theFiles[batchCurrentNum] quiet:true

		saveConfig()
		)
)
--	-------------------------------------------------------------------

fn cal3DExportFull =
--	Checks the presence of Named Selection Sets before calling the interface
--	(Other pre-requisites are handled by the dialog window events)
--	-------------------------------------------------------------------
(
	--	Test the selection sets
	if (getNumNamedSelSets()==0) do
	(
		MessageBox "This utility works with Named Selection Sets.\nDefine Named Selection Sets that represent :	\n	. the objects to export,\n	. the skeleton root(s),\n	. the animated bones\nbefore using this tool."
		return()
	)
	--	Everything seems fine, continue
	createDialog cal3DexportR
)


--	-------------------------------------------------------------------
--	MacroScript definition
--	-------------------------------------------------------------------
macroScript exportVizardCAL3D category:"Scripts" buttonText:"Vizard CAL3D Export" toolTip:"Vizard CAL3D - Export the selected skinned objects" icon:#("Maintoolbar", 93)
(
	fname = scriptsPath + "export_cal3D\\export_cal3D_vizard.ms"
	if keyboard.shiftpressed then
		edit fname
	else
		fileIn fname
)

cal3DExportFull()



